Attribute VB_Name = "API"
Option Explicit

Private Const LB_SETCURSEL = &H186
Private Const CB_SETCURSEL = &H14E
Private Const CB_FINDSTRING = &H14C
Private Const LB_SETSEL = &H185

Private Declare Function SendMessage Lib "user32" Alias _
   "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, _
             ByVal wParam As Long, lParam As Any) As Long

Private Declare Function SendMessageLong Lib "user32" Alias _
   "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Integer, _
   ByVal wParam As Long, ByVal lParam As Long) As Long

Private Declare Function GetPrivateProfileString Lib "kernel32" Alias _
   "GetPrivateProfileStringA" (ByVal SectionName As String, _
      ByVal KeyName As String, ByVal Default As String, _
      ByVal ReturnedString As String, ByVal StringSize As Long, _
      ByVal FileName As String) As Long

Private Declare Function WritePrivateProfileString Lib "kernel32" Alias _
   "WritePrivateProfileStringA" (ByVal SectionName As String, _
      ByVal KeyName As String, ByVal KeyValue As String, _
      ByVal FileName As String) As Long

Private Declare Function DeleteKeyValue Lib "kernel32" Alias _
   "WritePrivateProfileStringA" (ByVal SectionName As String, _
      ByVal KeyName As String, ByVal KeyValue As Long, _
      ByVal FileName As String) As Long

'Subclassing
Public Const GWL_WNDPROC = -4
Public lpPrevWndProc As Long
Public gHW As Long

Declare Function CallWindowProc Lib "user32" Alias _
   "CallWindowProcA" (ByVal lpPrevWndFunc As Long, _
      ByVal hwnd As Long, ByVal Msg As Long, _
      ByVal wParam As Long, ByVal lParam As Long) As Long

Declare Function SetWindowLong Lib "user32" Alias _
   "SetWindowLongA" (ByVal hwnd As Long, _
      ByVal nIndex As Long, ByVal dwNewLong As Long) As Long


Public Sub SetListIndex(lst As Object, ByVal NewIndex As Long)
                             
   If TypeOf lst Is ListBox Then
   
      Call SendMessage(lst.hwnd, LB_SETCURSEL, NewIndex, 0&)
      
   Else
   
      Call SendMessage(lst.hwnd, CB_SETCURSEL, NewIndex, 0&)
   
   End If

End Sub

Public Sub FindString(ByVal Combo As ComboBox, ByRef KeyAscii As Integer)

   Dim ComboText As String
   Dim Result As Long
    
   ComboText = Left$(Combo.Text, Combo.SelStart) & Chr(KeyAscii)
    
   Result = SendMessage(Combo.hwnd, CB_FINDSTRING, -1, ByVal ComboText)
    
   If Result <> -1 Then
        
      Combo.ListIndex = Result
      Combo.Text = Combo.List(Result)
      Combo.SelStart = Len(ComboText)
      Combo.SelLength = Len(Combo.Text)
        
      KeyAscii = 0
    
   End If

End Sub

Public Sub SelectItemsInListbox(ListBox As ListBox, Selected As Boolean)

   SendMessageLong ListBox.hwnd, LB_SETSEL, Selected, -1

End Sub

'Returns a key value from the ini file.
Public Function GetKeyValue(ByVal INIFile As String, _
   ByVal Section As String, ByVal KeyName As String, _
   ByVal DefaultValue As String) As String

   Dim lRet As Long
   Dim sBuf As String * 128
      Dim NullPosition As Long

   lRet = GetPrivateProfileString(Section, KeyName, DefaultValue, _
                     sBuf, Len(sBuf), INIFile)

   NullPosition = InStr(sBuf, vbNullChar)
    
   If NullPosition > 0 Then
      GetKeyValue = Left$(sBuf, NullPosition - 1)
   Else
      GetKeyValue = sBuf
   End If
         
End Function

'Writes a key value to the INI file.
Public Sub SaveKeyValue(ByVal INIFile As String, ByVal Section As String, _
             ByVal KeyName As String, ByVal Setting As String)

   Dim lRet As Long
    
   lRet = WritePrivateProfileString(Section, KeyName, Setting, INIFile)
   
End Sub

'Deletes a key in the INI file.
Public Sub DeleteKey(ByVal INIFile As String, ByVal Section As String, _
             ByVal KeyName As String)

   Dim lRet As Long

      lRet = DeleteKeyValue(Section, KeyName, 0&, INIFile)

      If lRet = 0 Then
         'Raise Error "Cannot delete key."
   End If
   
End Sub

'Deletes a section in an INI file.
Public Function DeleteSection(ByVal INIFile As String, _
                ByVal Section As String) As Long

   DeleteSection = WritePrivateProfileString(Section, vbNullString, _
                                             vbNullString, INIFile)

End Function

Public Sub Hook()
   lpPrevWndProc = SetWindowLong(gHW, GWL_WNDPROC, AddressOf WindowProc)
End Sub

Public Sub Unhook()
   Dim temp As Long
   temp = SetWindowLong(gHW, GWL_WNDPROC, lpPrevWndProc)
End Sub

Function WindowProc(ByVal hw As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
   
   Debug.Print "Message: hw="; hw & vbTab & "Msg=" & uMsg; vbTab & "wParam=" & wParam & vbTab & "lParam=" & lParam
   WindowProc = CallWindowProc(lpPrevWndProc, hw, uMsg, wParam, lParam)

End Function


